" Vim syntax file
" Language:	SAS
" Maintainer:	James Kidd <james.kidd@covance.com>
" Last Change:	02 Jun 2003
" 		Added highlighting for additional keywords and such;
" 		Attempted to match SAS default syntax colors;
" 		Changed syncing so it doesn't lose colors on large blocks;
" 		Much thanks to Bob Heckel for knowledgeable tweaking.
"  For version 5.x: Clear all syntax items
"  For version 6.x: Quit when a syntax file was already loaded
if version < 600
   syntax clear
elseif exists("b:current_syntax")
   finish
endif

syn case ignore

syn region sasString	start=+"+  skip=+\\\\\|\\"+  end=+"+
syn region sasString	start=+'+  skip=+\\\\\|\\"+  end=+'+

" Want region from 'cards;' to ';' to be captured (Bob Heckel)
syn region sasCards	start="^\s*CARDS.*" end="^\s*;\s*$"
syn region sasCards	start="^\s*DATALINES.*" end="^\s*;\s*$"

syn match sasNumber	"-\=\<\d*\.\=[0-9_]\>"

syn region sasComment	start="/\*"  end="\*/" contains=sasTodo
" Ignore misleading //JCL SYNTAX... (Bob Heckel)
syn region sasComment	start="[^/][^/]/\*"  end="\*/" contains=sasTodo

" Allow highlighting of embedded TODOs (Bob Heckel)
syn match sasComment	"^\s*\*.*;" contains=sasTodo

" Allow highlighting of embedded TODOs (Bob Heckel)
syn match sasComment	";\s*\*.*;"hs=s+1 contains=sasTodo

" Handle macro comments too (Bob Heckel).
syn match sasComment	"^\s*%*\*.*;" contains=sasTodo

" This line defines macro variables in code.  HiLink at end of file
" defines the color scheme. Begin region with ampersand and end with
" any non-word character offset by -1; put ampersand in the skip list
" just in case it is used to concatenate macro variable values.

" Thanks to ronald hllwarth for this fix to an intra-versioning
" problem with this little feature

if version < 600
   syn region sasMacroVar	start="\&" skip="[_&]" end="\W"he=e-1
else		 " for the older Vim's just do it their way ...
   syn region sasMacroVar	start="&" skip="[_&]" end="\W"he=e-1
endif


" I dont think specific PROCs need to be listed if use this line (Bob Heckel).
syn match sasProc		"^\s*PROC \w\+"
syn keyword sasStep		RUN QUIT DATA


" Base SAS Procs - version 8.1

syn keyword sasConditional	DO ELSE END IF THEN UNTIL WHILE

syn keyword sasStatement	ABORT ARRAY ATTRIB BY CALL CARDS CARDS4 CATNAME
syn keyword sasStatement	CONTINUE DATALINES DATALINES4 DELETE DISPLAY
syn keyword sasStatement	DM DROP ENDSAS ERROR FILE FILENAME FOOTNOTE
syn keyword sasStatement	FORMAT GOTO INFILE INFORMAT INPUT KEEP
syn keyword sasStatement	LABEL LEAVE LENGTH LIBNAME LINK LIST LOSTCARD
syn keyword sasStatement	MERGE MISSING MODIFY OPTIONS OUTPUT PAGE
syn keyword sasStatement	PUT REDIRECT REMOVE RENAME REPLACE RETAIN
syn keyword sasStatement	RETURN SELECT SET SKIP STARTSAS STOP TITLE
syn keyword sasStatement	UPDATE WAITSAS WHERE WINDOW X SYSTASK

" Keywords that are used in Proc SQL
" I left them as statements because SAS's enhanced editor highlights
" them the same as normal statements used in data steps (Jim Kidd)

syn keyword sasStatement	ADD AND ALTER AS CASCADE CHECK CREATE
syn keyword sasStatement	DELETE DESCRIBE DISTINCT DROP FOREIGN
syn keyword sasStatement	FROM GROUP HAVING INDEX INSERT INTO IN
syn keyword sasStatement	KEY LIKE MESSAGE MODIFY MSGTYPE NOT
syn keyword sasStatement	NULL ON OR ORDER PRIMARY REFERENCES
syn keyword sasStatement	RESET RESTRICT SELECT SET TABLE
syn keyword sasStatement	UNIQUE UPDATE VALIDATE VIEW WHERE


syn match sasStatement	"FOOTNOTE\d" "TITLE\d"

syn match sasMacro	"%BQUOTE" "%NRBQUOTE" "%CMPRES" "%QCMPRES"
syn match sasMacro	"%COMPSTOR" "%DATATYP" "%DISPLAY" "%DO"
syn match sasMacro	"%ELSE" "%END" "%EVAL" "%GLOBAL"
syn match sasMacro	"%GOTO" "%IF" "%INDEX" "%INPUT"
syn match sasMacro	"%KEYDEF" "%LABEL" "%LEFT" "%LENGTH"
syn match sasMacro	"%LET" "%LOCAL" "%LOWCASE" "%MACRO"
syn match sasMacro	"%MEND" "%NRBQUOTE" "%NRQUOTE" "%NRSTR"
syn match sasMacro	"%PUT" "%QCMPRES" "%QLEFT" "%QLOWCASE"
syn match sasMacro	"%QSCAN" "%QSUBSTR" "%QSYSFUNC" "%QTRIM"
syn match sasMacro	"%QUOTE" "%QUPCASE" "%SCAN" "%STR"
syn match sasMacro	"%SUBSTR" "%SUPERQ" "%SYSCALL" "%SYSEVALF"
syn match sasMacro	"%SYSEXEC" "%SYSFUNC" "%SYSGET" "%SYSLPUT"
syn match sasMacro	"%SYSPROD" "%SYSRC" "%SYSRPUT" "%THEN"
syn match sasMacro	"%TO" "%TRIM" "%UNQUOTE" "%UNTIL"
syn match sasMacro	"%UPCASE" "%VERIFY" "%WHILE" "%WINDOW"

" SAS Functions

syn keyword sasFunction	ABS ADDR AIRY ARCOS ARSIN ATAN ATTRC ATTRN
syn keyword sasFunction	BAND BETAINV BLSHIFT BNOT BOR BRSHIFT BXOR
syn keyword sasFunction	BYTE CDF CEIL CEXIST CINV CLOSE CNONCT COLLATE
syn keyword sasFunction	COMPBL COMPOUND COMPRESS COS COSH CSS CUROBS
syn keyword sasFunction	CV DACCDB DACCDBSL DACCSL DACCSYD DACCTAB
syn keyword sasFunction	DAIRY DATE DATEJUL DATEPART DATETIME DAY
syn keyword sasFunction	DCLOSE DEPDB DEPDBSL DEPDBSL DEPSL DEPSL
syn keyword sasFunction	DEPSYD DEPSYD DEPTAB DEPTAB DEQUOTE DHMS
syn keyword sasFunction	DIF DIGAMMA DIM DINFO DNUM DOPEN DOPTNAME
syn keyword sasFunction	DOPTNUM DREAD DROPNOTE DSNAME ERF ERFC EXIST
syn keyword sasFunction	EXP FAPPEND FCLOSE FCOL FDELETE FETCH FETCHOBS
syn keyword sasFunction	FEXIST FGET FILEEXIST FILENAME FILEREF FINFO
syn keyword sasFunction	FINV FIPNAME FIPNAMEL FIPSTATE FLOOR FNONCT
syn keyword sasFunction	FNOTE FOPEN FOPTNAME FOPTNUM FPOINT FPOS
syn keyword sasFunction	FPUT FREAD FREWIND FRLEN FSEP FUZZ FWRITE
syn keyword sasFunction	GAMINV GAMMA GETOPTION GETVARC GETVARN HBOUND
syn keyword sasFunction	HMS HOSTHELP HOUR IBESSEL INDEX INDEXC
syn keyword sasFunction	INDEXW INPUT INPUTC INPUTN INT INTCK INTNX
syn keyword sasFunction	INTRR IRR JBESSEL JULDATE KURTOSIS LAG LBOUND
syn keyword sasFunction	LEFT LENGTH LGAMMA LIBNAME LIBREF LOG LOG10
syn keyword sasFunction	LOG2 LOGPDF LOGPMF LOGSDF LOWCASE MAX MDY
syn keyword sasFunction	MEAN MIN MINUTE MOD MONTH MOPEN MORT N
syn keyword sasFunction	NETPV NMISS NORMAL NOTE NPV OPEN ORDINAL
syn keyword sasFunction	PATHNAME PDF PEEK PEEKC PMF POINT POISSON POKE
syn keyword sasFunction	PROBBETA PROBBNML PROBCHI PROBF PROBGAM
syn keyword sasFunction	PROBHYPR PROBIT PROBNEGB PROBNORM PROBT PUT
syn keyword sasFunction	PUTC PUTN QTR QUOTE RANBIN RANCAU RANEXP
syn keyword sasFunction	RANGAM RANGE RANK RANNOR RANPOI RANTBL RANTRI
syn keyword sasFunction	RANUNI REPEAT RESOLVE REVERSE REWIND RIGHT
syn keyword sasFunction	ROUND SAVING SCAN SDF SECOND SIGN SIN SINH
syn keyword sasFunction	SKEWNESS SOUNDEX SPEDIS SQRT STD STDERR STFIPS
syn keyword sasFunction	STNAME STNAMEL SUBSTR SUM SYMGET SYSGET SYSMSG
syn keyword sasFunction	SYSPROD SYSRC SYSTEM TAN TANH TIME TIMEPART
syn keyword sasFunction	TINV TNONCT TODAY TRANSLATE TRANWRD TRIGAMMA
syn keyword sasFunction	TRIM TRIMN TRUNC UNIFORM UPCASE USS VAR
syn keyword sasFunction	VARFMT VARINFMT VARLABEL VARLEN VARNAME
syn keyword sasFunction	VARNUM VARRAY VARRAYX VARTYPE VERIFY VFORMAT
syn keyword sasFunction	VFORMATD VFORMATDX VFORMATN VFORMATNX VFORMATW
syn keyword sasFunction	VFORMATWX VFORMATX VINARRAY VINARRAYX VINFORMAT
syn keyword sasFunction	VINFORMATD VINFORMATDX VINFORMATN VINFORMATNX
syn keyword sasFunction	VINFORMATW VINFORMATWX VINFORMATX VLABEL
syn keyword sasFunction	VLABELX VLENGTH VLENGTHX VNAME VNAMEX VTYPE
syn keyword sasFunction	VTYPEX WEEKDAY YEAR YYQ ZIPFIPS ZIPNAME ZIPNAMEL
syn keyword sasFunction	ZIPSTATE

" Handy settings for using vim with log files
syn keyword sasLogMsg	NOTE
syn keyword sasWarnMsg	WARNING
syn keyword sasErrMsg	ERROR

" Always contained in a comment (Bob Heckel)
syn keyword sasTodo	TODO TBD FIXME contained

" These don't fit anywhere else (Bob Heckel).
syn match sasUnderscore	"_NULL_"
syn match sasUnderscore	"_INFILE_"
syn match sasUnderscore	"_N_"
syn match sasUnderscore	"_WEBOUT_"
syn match sasUnderscore	"_NUMERIC_"
syn match sasUnderscore	"_CHARACTER_"
syn match sasUnderscore	"_ALL_"

" End of SAS Functions

"  Define the default highlighting.
"  For version 5.7 and earlier: only when not done already
"  For version 5.8 and later: only when an item doesn't have highlighting yet

if version >= 508 || !exists("did_sas_syntax_inits")
   if version < 508
      let did_sas_syntax_inits = 1
      command -nargs=+ HiLink hi link <args>
   else
      command -nargs=+ HiLink hi def link <args>
   endif

   " Default sas enhanced editor color syntax
	hi sComment	term=bold cterm=NONE ctermfg=Green ctermbg=Black gui=NONE guifg=DarkGreen guibg=White
	hi sCard	term=bold cterm=NONE ctermfg=Black ctermbg=Yellow gui=NONE guifg=Black guibg=LightYellow
	hi sDate_Time	term=NONE cterm=bold ctermfg=Green ctermbg=Black gui=bold guifg=SeaGreen guibg=White
	hi sKeyword	term=NONE cterm=NONE ctermfg=Blue  ctermbg=Black gui=NONE guifg=Blue guibg=White
	hi sFmtInfmt	term=NONE cterm=NONE ctermfg=LightGreen ctermbg=Black gui=NONE guifg=SeaGreen guibg=White
	hi sString	term=NONE cterm=NONE ctermfg=Magenta ctermbg=Black gui=NONE guifg=Purple guibg=White
	hi sText	term=NONE cterm=NONE ctermfg=White ctermbg=Black gui=bold guifg=Black guibg=White
	hi sNumber	term=NONE cterm=bold ctermfg=Green ctermbg=Black gui=bold guifg=SeaGreen guibg=White
	hi sProc	term=NONE cterm=bold ctermfg=Blue ctermbg=Black gui=bold guifg=Navy guibg=White
	hi sSection	term=NONE cterm=bold ctermfg=Blue ctermbg=Black gui=bold guifg=Navy guibg=White
	hi mDefine	term=NONE cterm=bold ctermfg=White ctermbg=Black gui=bold guifg=Black guibg=White
	hi mKeyword	term=NONE cterm=NONE ctermfg=Blue ctermbg=Black gui=NONE guifg=Blue guibg=White
	hi mReference	term=NONE cterm=bold ctermfg=White ctermbg=Black gui=bold guifg=Blue guibg=White
	hi mSection	term=NONE cterm=NONE ctermfg=Blue ctermbg=Black gui=bold guifg=Navy guibg=White
	hi mText	term=NONE cterm=NONE ctermfg=White ctermbg=Black gui=bold guifg=Black guibg=White

" Colors that closely match SAS log colors for default color scheme
	hi lError	term=NONE cterm=NONE ctermfg=Red ctermbg=Black gui=none guifg=Red guibg=White
	hi lWarning	term=NONE cterm=NONE ctermfg=Green ctermbg=Black gui=none guifg=Green guibg=White
	hi lNote	term=NONE cterm=NONE ctermfg=Cyan ctermbg=Black gui=none guifg=Blue guibg=White


   " Special hilighting for the SAS proc section

	HiLink	sasComment	sComment
	HiLink	sasConditional	sKeyword
	HiLink	sasStep		sSection
	HiLink	sasFunction	sKeyword
	HiLink	sasMacro	mKeyword
	HiLink	sasMacroVar	NonText
	HiLink	sasNumber	sNumber
	HiLink	sasStatement	sKeyword
	HiLink	sasString	sString
	HiLink	sasProc		sProc
   " (Bob Heckel)
	HiLink	sasTodo		Todo
	HiLink	sasErrMsg	lError
	HiLink	sasWarnMsg	lWarning
	HiLink	sasLogMsg	lNote
	HiLink	sasCards	sCard
  " (Bob Heckel)
	HiLink	sasUnderscore	PreProc
	delcommand HiLink
endif

" Syncronize from beginning to keep large blocks from losing
" syntax coloring while moving through code.
syn sync fromstart

let b:current_syntax = "sas"

" vim: ts=8
